<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(getAppName()); ?></title>
    <!-- Favicon -->
    <link rel="icon" href="<?php echo e(getSettingValue('favicon_icon')); ?>" type="image/png">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- Fonts -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
    <!-- General CSS Files -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/third-party.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/style.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/plugins.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(mix('assets/css/page.css')); ?>">
    <!-- CSS Libraries -->
    <?php echo $__env->yieldPushContent('css'); ?>
    <?php echo $__env->yieldContent('css'); ?>
</head>

<body>
    <div
        class="d-flex flex-column flex-column-fluid bgi-position-y-bottom position-x-center bgi-no-repeat bgi-size-contain bgi-attachment-fixed authImage">
        <?php echo $__env->make('auth.change_language_button', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('content'); ?>
    </div>
    <footer>
        <div class="container-fluid padding-0">
            <div class="row align-items-center justify-content-center">
                <div class="col-xl-6">
                    <div class="copyright text-center text-muted">
                        <?php echo e(__('messages.common.all_rights_reserved')); ?> &copy; <?php echo e(date('Y')); ?> <a
                            href="<?php echo e(url('/')); ?>" class="font-weight-bold ml-1"
                            target="_blank"><?php echo e(getAppName()); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- Scripts -->
    <script src="<?php echo e(asset('messages.js')); ?>"></script>
    <script src="<?php echo e(mix('assets/js/auth-third-party.js')); ?>"></script>
    <script src="<?php echo e(mix('assets/js/auth/auth.js')); ?>"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
    <script>
        $(document).ready(function() {
            $('.alert').delay(5000).slideUp(300)
        });
        let changeLanguageUrl = "<?php echo e(route('set.language')); ?>";
    </script>
</body>

</html>
<?php /**PATH /Users/fowusu/Herd/revoinvoice/resources/views/layouts/auth.blade.php ENDPATH**/ ?>