<!DOCTYPE HTML>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <link rel="icon" href="<?php echo e(asset('web/media/logos/favicon.ico')); ?>" type="image/png">
    <title><?php echo e(__('messages.invoice.invoice_pdf')); ?></title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/css/invoice-pdf.css')); ?>" rel="stylesheet" type="text/css" />
    <style>
        * {
            font-family: DejaVu Sans, Arial, "Helvetica", Arial, "Liberation Sans", sans-serif;
        }

        @page {
            margin-top: 40px !important;
        }

        <?php if(getInvoiceCurrencyIcon($invoice->currency_id) == '€'): ?>
            .euroCurrency {
                font-family: Arial, "Helvetica", Arial, "Liberation Sans", sans-serif;
            }
        <?php endif; ?>
    </style>
</head>

<body style="padding: 0rem 2rem;">
    <?php $styleCss = 'style'; ?>
    <div class="preview-main client-preview mumbai-template">
        <div class="d" id="boxes">
            <div class="d-inner">
                <div class="top-border" style="background-color: <?php echo e($invoice_template_color); ?>;"></div>
                <div style="background-color: <?php echo e($invoice_template_color); ?>;">
                    <table class="pb-10 bg-white w-100 m-0 h-125px" style="overflow:hidden;">
                        <tr>
                            <td class=" p-0 m-0 " style="width:66%; overflow:hidden !important;  ">
                                <div class="bg-white  h-125px" style=" border-top-right-radius:30px; padding:24.5px;">
                                    <img width="100px" height="66px" src="<?php echo e(getLogoUrl()); ?>" class="img-logo"
                                        alt="logo">
                                </div>
                            </td>
                            <td class="bg-white p-0 m-0 h-125px"
                                style="width:33%;border-bottom-left-radius:30px; overflow:hidden;">
                                <div class="text-end p-4 pt-10 h-125px"
                                    style=" background-color: <?php echo e($invoice_template_color); ?>;">
                                    <h1 class="m-0 pt-4 text-white pe-2"
                                        style=" font-size: 36px; font-weight:700; letter-spacing: 4px;">
                                        <?php echo e(__('messages.common.invoice')); ?></h1>
                                </div>
                            </td>
                        </tr>
                    </table>
                    <div class="px-4 py-4 bg-white" style="margin-right:10px;">
                        <div class="pb-3">
                            <table class="mb-10 w-100">
                                <tbody>
                                    <tr style="vertical-align:top;">
                                        <td width="33.33%">
                                            <p class="fs-6 mb-2 font-gray-900">
                                                <strong><?php echo e(__('messages.common.to') . ':'); ?></strong>
                                            </p>
                                            <p class=" mb-1 font-color-gray fs-6">
                                                <?php echo e(__('messages.common.name') . ':'); ?>

                                                <span class="font-gray-900"><?php echo e($client->user->full_name); ?></span>
                                            </p>
                                            <p class=" mb-1 font-color-gray fs-6">
                                                <?php echo e(__('messages.common.email') . ':'); ?>

                                                <span class="font-gray-900"><?php echo e($client->user->email); ?></span>
                                            </p>
                                            <p class=" mb-1  font-color-gray fs-6">
                                                <?php echo e(__('messages.common.address') . ':'); ?>

                                                <span class="font-gray-900"><?php echo e($client->address); ?> </span>
                                            </p>
                                            <?php if(!empty($client->vat_no)): ?>
                                                <p class=" mb-1  font-color-gray fs-6">
                                                    <?php echo e(getVatNoLabel() . ':'); ?>

                                                    <span class="font-gray-900"><?php echo e($client->vat_no); ?> </span>
                                                </p>
                                            <?php endif; ?>
                                        </td>
                                        <td width="33.33%">
                                            <p class="fs-6 mb-2 font-gray-900">
                                                <strong><?php echo e(__('messages.common.from') . ':'); ?></strong>
                                            </p>
                                            <p class="mb-1 font-color-gray fw-bold fs-6">
                                                <?php echo e(__('messages.common.name') . ':'); ?>&nbsp; <span
                                                    class="font-gray-900"><?php echo $setting['company_name']; ?></span></p>
                                            <p class=" mb-1 font-color-gray fw-bold fs-6">
                                                <?php echo e(__('messages.common.address') . ':'); ?>&nbsp; <span
                                                    class="font-gray-900"><?php echo $setting['company_address']; ?></span></p>
                                            <?php if(isset($setting['show_additional_address_in_invoice']) && $setting['show_additional_address_in_invoice'] == 1): ?>
                                                <p class=" m-0 font-color-gray fs-6">
                                                    <?php echo e($setting['zipcode'] . ', ' . $setting['city'] . ', ' . $setting['state'] . ', ' . $setting['country']); ?>

                                                </p>
                                            <?php endif; ?>
                                            <p class=" mb-1 font-color-gray  fw-bold fs-6">
                                                <?php echo e(__('messages.user.phone') . ':'); ?>&nbsp; <span
                                                    class="font-gray-900"><?php echo e($setting['company_phone']); ?></span></p>
                                            <?php if(isset($setting['show_additional_address_in_invoice']) && $setting['show_additional_address_in_invoice'] == 1): ?>
                                                <p class="mb-1 font-color-gray  fw-bold fs-6">
                                                    <strong><?php echo e(__('messages.invoice.fax_no') . ':'); ?>&nbsp;</strong><span
                                                        class="font-gray-900"><?php echo e($setting['fax_no']); ?></span>
                                                <p>
                                            <?php endif; ?>
                                            <?php if(!empty($setting['gst_no'])): ?>
                                                <p class="mb-1 font-color-gray fs-6">
                                                    <?php echo e(getVatNoLabel() . ':'); ?>

                                                    <span class="font-gray-900"><?php echo e($setting['gst_no']); ?> </span>
                                                </p>
                                            <?php endif; ?>
                                        </td>
                                        <td width="33.33%" class="text-end pt-7">
                                            <p class="mb-1 text-gray-600 fs-6"><strong
                                                    class="font-gray-900"><?php echo e(__('messages.invoice.invoice_id') . ':'); ?>

                                                </strong>#<?php echo e($invoice->invoice_id); ?>

                                            </p>
                                            <p class="mb-1 text-gray-600 fs-6"><strong
                                                    class="font-gray-900"><?php echo e(__('messages.invoice.invoice_date') . ':'); ?>

                                                </strong><?php echo e(\Carbon\Carbon::parse($invoice->invoice_date)->translatedFormat(currentDateFormat())); ?>

                                            </p>
                                            <p class="mb-1 text-gray-600 fs-6"><strong
                                                    class="font-gray-900"><?php echo e(__('messages.invoice.due_date') . ':'); ?>&nbsp;
                                                </strong><?php echo e(\Carbon\Carbon::parse($invoice->due_date)->translatedFormat(currentDateFormat())); ?>

                                            </p>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="overflow-auto">
                            <table class="invoice-table w-100">
                                <thead style="background-color: <?php echo e($invoice_template_color); ?>;">
                                    <tr>
                                        <th class="p-2 text-uppercase" style="width:5% !important;">#</th>
                                        <th class="p-2 in-w-2 text-uppercase"><?php echo e(__('messages.product.product')); ?>

                                        </th>
                                        <th class="p-2 text-center text-uppercase" style="width:9% !important;">
                                            <?php echo e(__('messages.invoice.qty')); ?>

                                        </th>
                                        <th class="p-2 text-center  text-nowrap text-uppercase"
                                            style="width:15% !important;">
                                            <?php echo e(__('messages.product.unit_price')); ?></th>
                                        <th class="p-2 text-center  text-nowrap text-uppercase"
                                            style="width:13% !important;">
                                            <?php echo e(__('messages.invoice.tax') . '(in %)'); ?>

                                        </th>
                                        <th class="p-2 text-end  text-nowrap text-uppercase"
                                            style="width:14% !important;">
                                            <?php echo e(__('messages.invoice.amount')); ?>

                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if(isset($invoice) && !empty($invoice)): ?>
                                        <?php $__currentLoopData = $invoice->invoiceItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $invoiceItems): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="p-2" style="width:5%;">
                                                    <span><?php echo e($key + 1); ?></span>
                                                </td>
                                                <td class="p-2 in-w-2">
                                                    <p class="fw-bold mb-0">
                                                        <?php echo e(isset($invoiceItems->product->name) ? $invoiceItems->product->name : $invoiceItems->product_name ?? __('messages.common.n/a')); ?>

                                                    </p>
                                                    <?php if(
                                                        !empty($invoiceItems->product->description) &&
                                                            (isset($setting['show_product_description']) && $setting['show_product_description'] == 1)): ?>
                                                    <?php endif; ?>
                                                    <?php if(
                                                        !empty($invoiceItems->product->description) &&
                                                            (isset($setting['show_product_description']) && $setting['show_product_description'] == 1)): ?>
                                                        <span
                                                            style="font-size: 12px; word-break: break-all !important"><?php echo e($invoiceItems->product->description); ?></span>
                                                    <?php endif; ?>
                                                </td>
                                                <td class="p-2 text-center">
                                                    <?php echo e(number_format($invoiceItems->quantity, 2)); ?>

                                                </td>
                                                <td class="p-2 text-center">
                                                    <?php echo e(isset($invoiceItems->price) ? getInvoiceCurrencyAmount($invoiceItems->price, $invoice->currency_id, true) : __('messages.common.n/a')); ?>

                                                </td>
                                                <td class="p-2 text-center">
                                                    <?php $__currentLoopData = $invoiceItems->invoiceItemTax; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keys => $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php echo e($tax->tax ?? '--'); ?>

                                                        <?php if(!$loop->last): ?>
                                                            ,
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </td>
                                                <td class="p-2 text-end">
                                                    <?php echo e(isset($invoiceItems->total) ? getInvoiceCurrencyAmount($invoiceItems->total, $invoice->currency_id, true) : __('messages.common.n/a')); ?>

                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="my-5">
                            <table class="w-100">
                                <tr>
                                    <?php if(!empty($invoice->paymentQrCode)): ?>
                                        <td style="vertical-align:bottom; width:60%;">
                                            <img class="mt-4" src="<?php echo e($invoice->paymentQrCode->qr_image); ?>"
                                                height="100" width="100" alt="qr-code-image">
                                        </td>
                                    <?php endif; ?>
                                    <td style="vertical-align:top; width:40%;">
                                        <table class="w-100">
                                            <tbody>
                                                <tr>
                                                    <td class="py-1 px-2">
                                                        <strong><?php echo e(__('messages.invoice.sub_total') . ':'); ?></strong>
                                                    </td>
                                                    <td class="text-end font-gray-600 py-1 px-2 fw-bold">
                                                        <?php echo e(getInvoiceCurrencyAmount($invoice->amount, $invoice->currency_id, true)); ?>

                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="py-1 px-2">
                                                        <strong><?php echo e(__('messages.invoice.discount') . ':'); ?></strong>
                                                    </td>
                                                    <td class="text-end font-gray-600 py-1 px-2 fw-bold">
                                                        <?php if($invoice->discount == 0): ?>
                                                            <span><?php echo e(__('messages.common.n/a')); ?></span>
                                                        <?php else: ?>
                                                            <?php if(isset($invoice) && $invoice->discount_type == \App\Models\Invoice::FIXED): ?>
                                                                <b
                                                                    class="euroCurrency"><?php echo e(isset($invoice->discount) ? getInvoiceCurrencyAmount($invoice->discount, $invoice->currency_id, true) : __('messages.common.n/a')); ?></b>
                                                            <?php else: ?>
                                                                <?php echo e($invoice->discount); ?><span
                                                                    <?php echo e($styleCss); ?>="font-family: DejaVu Sans">&#37;</span>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <?php
                                                        $itemTaxesAmount = $invoice->amount + array_sum($totalTax);
                                                        $invoiceTaxesAmount =
                                                            ($itemTaxesAmount * $invoice->invoiceTaxes->sum('value')) /
                                                            100;
                                                        $totalTaxes = array_sum($totalTax) + $invoiceTaxesAmount;
                                                    ?>
                                                    <td class="py-1 px-2">
                                                        <strong><?php echo e(__('messages.invoice.tax') . ':'); ?></strong>
                                                    </td>
                                                    <td class="text-end font-gray-600 py-1 px-2 fw-bold">
                                                        <?php echo numberFormat($totalTaxes) != 0
                                                            ? '<b class="euroCurrency">' . getInvoiceCurrencyAmount($totalTaxes, $invoice->currency_id, true) . '</b>'
                                                            : __('messages.common.n/a'); ?>

                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="py-1 px-2">
                                                        <strong><?php echo e(__('messages.invoice.total') . ':'); ?></strong>
                                                    </td>
                                                    <td class="text-end font-gray-600 py-1 px-2 fw-bold">
                                                        <?php echo e(getInvoiceCurrencyAmount($invoice->final_amount, $invoice->currency_id, true)); ?>

                                                    </td>
                                                </tr>
                                            </tbody>
                                            <tfoot class="total-amount"
                                                <?php echo e($styleCss); ?>="background-color: <?php echo e($invoice_template_color); ?>;">
                                                <tr>
                                                    <td class="p-2">
                                                        <strong><?php echo e(__('messages.admin_dashboard.total_due') . ':'); ?></strong>
                                                    </td>
                                                    <td class="text-end p-2">
                                                        <strong>
                                                            <?php echo e(getInvoiceCurrencyAmount(getInvoiceDueAmount($invoice->id), $invoice->currency_id, true)); ?></strong>
                                                    </td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div class="mt-20">
                            <?php if(!empty($invoice->note)): ?>
                            <div class="mb-5 pt-10">
                                <h6 class="font-gray-900 mb5"><b><?php echo __('messages.client.notes'); ?>:</b></h6>
                                <p class="font-gray-600"><?php echo nl2br($invoice->note ?? __('messages.common.not_available')); ?>

                                </p>
                            </div>
                            <?php endif; ?>
                            <div class="position-relative">
                                <?php if(!empty($invoice->term)): ?>
                                <div class="w-75">
                                    <h6 class="font-gray-900">
                                        <b><?php echo e(__('messages.invoice.terms') . ':'); ?></b>
                                    </h6>
                                    <p class="font-gray-600 mb-0">
                                        <?php echo nl2br($invoice->term ?? __('messages.common.not_available')); ?>

                                    </p>
                                </div>
                                <?php endif; ?>
                                <div class="text-end w-25"
                                    style="position:relative;
                                 top:-50px;
                                 margin-left:auto;">
                                    <h5 class="text-indigo mt-2"
                                        <?php echo e($styleCss); ?>="color:<?php echo e($invoice_template_color); ?>">
                                        <b><?php echo e(__('messages.setting.regards') . ':'); ?></b>
                                    </h5>
                                    <p class="fs-6 mb-0"><b> <?php echo e(getAppName()); ?></b></p>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div>
                        <table class="w-100 bg-white">
                            <tr>
                                <td class=" p-0 h-25px" style="width:80% !important; overflow:hidden;">
                                    <div class="bg-white h-25px"
                                        style=" border-bottom-right-radius:30px; padding:26px;">
                                    </div>
                                </td>
                                <td class="bg-white p-0 h-25px"
                                    style="width:20%; border-top-left-radius:35px; overflow:hidden;">
                                    <div class="text-end h-25px"
                                        style="background-color: <?php echo e($invoice_template_color); ?>;  padding:26px;">
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="bottom-border" style="background-color: <?php echo e($invoice_template_color); ?>"></div>
                </div>
            </div>
        </div>
    </div>
</body>

</html>
<?php /**PATH /Users/fowusu/Herd/ims/resources/views/invoices/invoice_template_pdf/mumbaiTemplate.blade.php ENDPATH**/ ?>