<?php $__env->startSection('title'); ?>
    <?php echo e(__('messages.client.edit_client')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php $styleCss = 'style'; ?>
    <div class="container-fluid">
        <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="d-flex flex-column">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-end mb-5">
                    <h1><?php echo $__env->yieldContent('title'); ?></h1>
                    <a class="btn btn-outline-primary float-end"
                        href="<?php echo e(route('clients.index')); ?>"><?php echo e(__('messages.common.back')); ?></a>
                </div>
                <div class="col-12">
                    <?php echo $__env->make('layouts.errors', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="card">
                    <div class="card-body">
                        <?php echo e(Form::open(['route' => ['clients.update', $client->id], 'method' => 'put', 'files' => 'true', 'id' => 'editClientForm'])); ?>

                        <?php echo $__env->make('clients.edit_fields', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo e(Form::close()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo e(Form::hidden('phone_no', !empty($client) ? $client->user->region_code . $client->user->contact : null, ['id' => 'phoneNo'])); ?>

    <?php echo e(Form::hidden('is_edit', true, ['id' => 'isEdit'])); ?>

    <?php echo e(Form::hidden('country_id', $client->country_id, ['id' => 'clientCountryId'])); ?>

    <?php echo e(Form::hidden('state_id', $client->state_id, ['id' => 'clientStateId'])); ?>

    <?php echo e(Form::hidden('city_id', $client->city_id, ['id' => 'clientCityId'])); ?>

    <?php echo e(Form::hidden('default_avatar_image_url', asset('assets/images/avatar.png'), ['id' => 'defaultAvatarImageUrl'])); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('phone_js'); ?>
    <script>
        phoneNo = "<?php echo e(!empty($client) ? $client->user->region_code . $client->user->contact : null); ?>";
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/fowusu/Herd/revoinvoice/resources/views/clients/edit.blade.php ENDPATH**/ ?>