<!doctype html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <link rel="icon" href="<?php echo e(asset('web/media/logos/favicon.ico')); ?>" type="image/png">
    <title><?php echo e(__('messages.invoice.invoice_pdf')); ?></title>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS v5.2.1 -->
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/css/invoice-pdf.css')); ?>" rel="stylesheet" type="text/css" />
</head>

<body style="padding: 30px 15px !important;">
    <?php $styleCss = 'style'; ?>
    <div>
        <div class="ml-2">
   
            <div class="logo"><img width="100px" src="<?php echo e(getLogoUrl()); ?>" alt="no-image">
            </div>
        </div>
        <div class="card-body">
            <table class="table table-bordered w-100">
                <thead class="bg-light">
                    <tr>
                        <th class="py-1 text-uppercase" style="width:33.33% !important;">
                            <?php echo e(__('messages.common.from')); ?></th>
                        <th class="py-1 text-uppercase" style="width:33.33% !important;"><?php echo e(__('messages.common.to')); ?>

                        </th>
                        <th class="py-1 text-uppercase" style="width:33.33% !important;">
                            <?php echo e(__('messages.common.invoice')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="py-1">
                            <b><?php echo e(__('messages.common.name') . ':'); ?>&nbsp;</b><?php echo e($setting['company_name']); ?><br>
                            <b><?php echo e(__('messages.common.address') . ':'); ?>&nbsp;</b><span
                                class="text-break"><?php echo $setting['company_address']; ?></span><br>
                            <?php if(isset($setting['show_additional_address_in_invoice']) && $setting['show_additional_address_in_invoice'] == 1): ?>
                                <div>
                                    <?php echo e($setting['country'] . ', ' . $setting['state'] . ', ' . $setting['city'] . ', ' . $setting['zipcode'] . '.'); ?>

                                </div>
                            <?php endif; ?>
                            <b><?php echo e(__('messages.user.phone') . ':'); ?>&nbsp;</b><?php echo e($setting['company_phone']); ?><br>
                            <?php if(isset($setting['show_additional_address_in_invoice']) && $setting['show_additional_address_in_invoice'] == 1): ?>
                                <div><b><?php echo e(__('messages.invoice.fax_no') . ':'); ?>&nbsp;</b><?php echo e($setting['fax_no']); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(!empty($setting['gst_no'])): ?>
                                <b><?php echo e(getVatNoLabel() . ':'); ?>&nbsp;</b><?php echo e($setting['gst_no']); ?>

                            <?php endif; ?>
                        </td>
                        <td class="py-1"
                            style=" overflow:hidden; word-wrap: break-word;
                word-break: break-all;">
                            <b><?php echo e(__('messages.common.name') . ':'); ?>&nbsp;</b><?php echo e($client->user->full_name); ?><br>
                            <b><?php echo e(__('messages.common.email') . ':'); ?>&nbsp;</b>
                            <div style="width:200px; word-break: break-all!important; ">
                                <?php echo e($client->user->email); ?></div>
                            <?php if(!empty($client->address)): ?>
                                <b><?php echo e(__('messages.common.address') . ':'); ?>&nbsp;</b><?php echo e($client->address); ?>

                            <?php endif; ?>
                            <?php if(!empty($client->vat_no)): ?>
                                <br><b><?php echo e(getVatNoLabel() . ':'); ?>&nbsp;</b><?php echo e($client->vat_no); ?>

                            <?php endif; ?>
                        </td>
                        <td class="py-1">
                            <div class="text-nowrap">
                                <b><?php echo e(__('messages.invoice.invoice_id') . ':'); ?></b>
                                &nbsp;#<?php echo e($invoice->invoice_id); ?>

                            </div>
                            <div>
                                <b><?php echo e(__('messages.invoice.invoice_date') . ':'); ?></b>
                                &nbsp;#<?php echo e(\Carbon\Carbon::parse($invoice->invoice_date)->translatedFormat(currentDateFormat())); ?>

                            </div>
                            <div>
                                <b><?php echo e(__('messages.invoice.due_date') . ':'); ?></b>
                                &nbsp;#<?php echo e(\Carbon\Carbon::parse($invoice->due_date)->translatedFormat(currentDateFormat())); ?>

                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="table-responsive-sm">
                <table class="table table-striped">
                    <thead class="bg-light">
                        <tr>
                            <th class="py-1" style="width:5%;">#</th>
                            <th class="py-1 text-uppercase"><?php echo e(__('messages.product.product')); ?></th>
                            <th class="py-1 text-uppercase" style="width:9%;"><?php echo e(__('messages.invoice.qty')); ?></th>
                            <th class="py-1 text-uppercase text-nowrap" style="width:13%;">
                                <?php echo e(__('messages.product.unit_price')); ?>

                            </th>
                            <th class="py-1 text-uppercase text-nowrap" style="width:12%;">
                                <?php echo e(__('messages.invoice.tax') . '(in %)'); ?></th>
                            <th class="py-1 text-uppercase  number-align text-nowrap" style="width:14%;">
                                <?php echo e(__('messages.invoice.amount')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(isset($invoice) && !empty($invoice)): ?>
                            <?php $__currentLoopData = $invoice->invoiceItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $invoiceItems): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($key + 1); ?></td>
                                    <?php if(
                                        !empty($invoiceItems->product->description) &&
                                            (isset($setting['show_product_description']) && $setting['show_product_description'] == 1)): ?>
                                        <td style="width: 30%!important;" class="py-0">
                                        <?php else: ?>
                                        <td>
                                    <?php endif; ?>
                                    <p class="m-0"
                                        style="width:150px!important;word-wrap: break-word;
                                word-break: break-all;">
                                        <?php echo e(isset($invoiceItems->product->name) ? $invoiceItems->product->name : $invoiceItems->product_name ?? __('messages.common.n/a')); ?>

                                    </p>
                                    <?php if(
                                        !empty($invoiceItems->product->description) &&
                                            (isset($setting['show_product_description']) && $setting['show_product_description'] == 1)): ?>
                                        <span
                                            style="font-size: 12px; word-break: break-all"><?php echo e($invoiceItems->product->description); ?></span>
                                    <?php endif; ?>
                                    </td>
                                    <td class="text-start text-nowrap"><?php echo e(number_format($invoiceItems->quantity, 2)); ?>

                                    </td>
                                    <td class="text-start text-nowrap euroCurrency">
                                        <?php echo e(isset($invoiceItems->price) ? getInvoiceCurrencyAmount($invoiceItems->price, $invoice->currency_id, true) : __('messages.common.n/a')); ?>

                                    </td>
                                    <td class="text-center text-nowrap">
                                        <?php $__currentLoopData = $invoiceItems->invoiceItemTax; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keys => $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo e($tax->tax ?? '--'); ?>

                                            <?php if(!$loop->last): ?>
                                                ,
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                    <td class="number-align text-nowrap euroCurrency">
                                        <?php echo e(isset($invoiceItems->total) ? getInvoiceCurrencyAmount($invoiceItems->total, $invoice->currency_id, true) : __('messages.common.n/a')); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <table class="mb-4 w-100">
                <tr>
                    <td class="w-75">
                        <?php if(!empty($invoice->paymentQrCode)): ?>
                            <div style="">
                                <strong
                                    style="font-size: ; margin-right: 142px"><b><?php echo e(__('messages.payment_qr_codes.payment_qr_code')); ?></b></strong><br>
                                <img class="mt-2 ml-3" src="<?php echo e($invoice->paymentQrCode->qr_image); ?>" height="110"
                                    width="110" alt="qr-code-image">
                            </div>
                        <?php endif; ?>
                    </td>
                    <td class="w-25 text-end">
                        <table>
                            <tbody class="text-end">
                                <tr>
                                    <td class="left" style="padding-right: 30px">
                                        <strong><?php echo e(__('messages.invoice.sub_total') . ':'); ?></strong>
                                    </td>
                                    <td class="euroCurrency">
                                        <?php echo e(getInvoiceCurrencyAmount($invoice->amount, $invoice->currency_id, true)); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <td class="left" style="padding-right: 30px">
                                        <strong><?php echo e(__('messages.invoice.discount') . ':'); ?></strong>
                                    </td>
                                    <td class="right">
                                        <?php if($invoice->discount == 0): ?>
                                            <span><?php echo e(__('messages.common.n/a')); ?></span>
                                        <?php else: ?>
                                            <?php if(isset($invoice) && $invoice->discount_type == \App\Models\Invoice::FIXED): ?>
                                                <b
                                                    class="euroCurrency"><?php echo e(isset($invoice->discount) ? getInvoiceCurrencyAmount($invoice->discount, $invoice->currency_id, true) : __('messages.common.n/a')); ?></b>
                                            <?php else: ?>
                                                <?php echo e($invoice->discount); ?><span
                                                    <?php echo e($styleCss); ?>="font-family: DejaVu Sans">&#37;</span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <?php
                                        $itemTaxesAmount = $invoice->amount + array_sum($totalTax);

                                        $invoiceTaxesAmount =
                                            ($itemTaxesAmount * $invoice->invoiceTaxes->sum('value')) / 100;
                                        $totalTaxes = array_sum($totalTax) + $invoiceTaxesAmount;
                                    ?>
                                    <td class="left" style="padding-right: 30px">
                                        <strong><?php echo e(__('messages.invoice.tax') . ':'); ?></strong>
                                    </td>

                                    <td class="right text-nowrap">
                                        <?php echo numberFormat($totalTaxes) != 0
                                            ? '<b class="euroCurrency">' . getInvoiceCurrencyAmount($totalTaxes, $invoice->currency_id, true) . '</b>'
                                            : __('messages.common.n/a'); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold" style="padding-right: 30px">
                                        <?php echo e(__('messages.invoice.total') . ':'); ?></td>
                                    <td class="text-nowrap">
                                        <b
                                            class="euroCurrency"><?php echo e(getInvoiceCurrencyAmount($invoice->final_amount, $invoice->currency_id, true)); ?></b>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold" style="padding-right: 30px">
                                        <?php echo e(__('messages.admin_dashboard.total_due') . ':'); ?>

                                    </td>
                                    <td class="text-nowrap" <?php echo e($styleCss); ?>="color: red">
                                        <b
                                            class="euroCurrency"><?php echo e(getInvoiceCurrencyAmount(getInvoiceDueAmount($invoice->id), $invoice->currency_id, true)); ?></b>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold text-nowrap" style="padding-right: 30px">
                                        <?php echo e(__('messages.admin_dashboard.total_paid') . ':'); ?></td>
                                    <td class="text-nowrap" <?php echo e($styleCss); ?>="color: green">
                                        <b
                                            class="euroCurrency"><?php echo e(getInvoiceCurrencyAmount(getInvoicePaidAmount($invoice->id), $invoice->currency_id, true)); ?></b>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </table>
            <?php if(!empty($invoice->note)): ?>
                <div class="alert alert-primary text-muted" role="alert">
                    <b class="text-dark"><?php echo e(__('messages.client.notes') . ':'); ?></b> <?php echo nl2br($invoice->note ?? __('messages.common.not_available')); ?>

                </div>
            <?php endif; ?>
            <?php if(!empty($invoice->term)): ?>
                <div class="alert alert-light text-muted" role="alert">
                    <b class="text-dark"><?php echo e(__('messages.invoice.terms') . ':'); ?></b> <?php echo nl2br($invoice->term ?? __('messages.common.not_available')); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>

</body>

</html>
<?php /**PATH /Users/fowusu/Herd/ims/resources/views/invoices/invoice_template_pdf/defaultTemplate.blade.php ENDPATH**/ ?>