<!DOCTYPE HTML>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <link rel="icon" href="<?php echo e(asset('web/media/logos/favicon.ico')); ?>" type="image/png">
    <title><?php echo e(__('messages.invoice.invoice_pdf')); ?></title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/css/invoice-pdf.css')); ?>" rel="stylesheet" type="text/css" />
    <style>
        * {
            font-family: DejaVu Sans, Arial, "Helvetica", Arial, "Liberation Sans", sans-serif;
        }

        @page {
            margin-top: 40px !important;
        }

        <?php if(getInvoiceCurrencyIcon($invoice->currency_id) == '€'): ?>
            .euroCurrency {
                font-family: Arial, "Helvetica", Arial, "Liberation Sans", sans-serif;
            }
        <?php endif; ?>
    </style>
</head>

<body style="padding: 0rem;">
    <div class="preview-main client-preview paris-template">
        <div class="d" id="boxes">
            <div class="d-inner bg-img">
                <div class="position-relative" style="padding:0 1.5rem;">
                    <div class="bg-img" style="position:absolute; left:0; top:-40px;  min-width:220px;">
                        <img src="<?php echo e(asset('images/paris-bg-img.png')); ?>" class="w-100" alt="paris-bg-img" />
                    </div>
                    <div class="px-3" style="margin-top:-40px; z-index:2;">
                        <table class="w-100">
                            <tr>
                                <td padding-right:8px;">
                                    <div>
                                        <img src="<?php echo e(getLogoUrl()); ?>" class="img-logo" alt="logo">
                                    </div>
                                </td>
                                <td class="heading-text" style="vertical-align:bottom; padding:1.5rem 0;">
                                    <div class="text-end">
                                        <h1 class="m-0" style="color:<?php echo e($invoice_template_color); ?>">
                                            <?php echo e(__('messages.common.invoice')); ?></h1>
                                    </div>
                                </td>
                            </tr>
                        </table>
                        <div>
                            <table class="w-100 mt-2">
                                <tr>
                                    <td class="text-end">
                                        <p class="mb-1 fw-6"><strong
                                                class="font-gray-900"><?php echo e(__('messages.invoice.invoice_id') . ':'); ?>&nbsp;
                                            </strong>
                                            <span class="font-gray-600">#<?php echo e($invoice->invoice_id); ?></span>
                                        </p>
                                        <p class="mb-1 fw-6"><strong
                                                class="font-gray-900"><?php echo e(__('messages.invoice.invoice_date') . ':'); ?>&nbsp;
                                            </strong>
                                            <span
                                                class="font-gray-600"><?php echo e(\Carbon\Carbon::parse($invoice->invoice_date)->translatedFormat(currentDateFormat())); ?></span>
                                        </p>
                                        <p class="mb-1 fw-6"><strong
                                                class="font-gray-900"><?php echo e(__('messages.invoice.due_date') . ':'); ?>&nbsp;
                                            </strong>
                                            <span
                                                class="font-gray-600"><?php echo e(\Carbon\Carbon::parse($invoice->due_date)->translatedFormat(currentDateFormat())); ?></span>
                                        </p>
                                    </td>
                                </tr>
                            </table>
                            <div class="overflow-auto">
                                <table class="mt-4 w-100">
                                    <tbody>
                                        <tr style="vertical-align:top;">
                                            <td width="40%" class="pe-3">
                                                <p class="mb-2" style="color:<?php echo e($invoice_template_color); ?>">
                                                    <strong><?php echo e(__('messages.common.from') . ':'); ?></strong>
                                                </p>
                                                <p class="mb-1 font-black-900 fw-bold" style="white-space:nowrap;">
                                                    <strong><?php echo e(__('messages.common.name') . ':'); ?>&nbsp;</strong><?php echo $setting['company_name']; ?>

                                                </p>
                                                <p class=" mb-1 font-black-900" style="max-width:220px;">
                                                    <strong><?php echo e(__('messages.common.address') . ':'); ?></b>&nbsp;</strong>
                                                    <?php echo $setting['company_address']; ?>

                                                </p>
                                                <?php if(isset($setting['show_additional_address_in_invoice']) && $setting['show_additional_address_in_invoice'] == 1): ?>
                                                    <p class="mb-1 font-black-900">
                                                        <?php echo e($setting['zipcode'] . ', ' . $setting['city'] . ', ' . $setting['state'] . ', ' . $setting['country']); ?>

                                                    </p>
                                                <?php endif; ?>
                                                <p class="mb-1 font-black-900" style="white-space:nowrap;">
                                                    <strong><?php echo e(__('messages.user.phone') . ':'); ?>

                                                    </strong><?php echo e($setting['company_phone']); ?>

                                                </p>
                                                <?php if(isset($setting['show_additional_address_in_invoice']) && $setting['show_additional_address_in_invoice'] == 1): ?>
                                                    <p class="mb-1 font-black-900" style="white-space:nowrap;">
                                                        <strong><?php echo e(__('messages.invoice.fax_no') . ':'); ?>

                                                        </strong><?php echo e($setting['fax_no']); ?>

                                                    </p>
                                                <?php endif; ?>
                                                    <?php if(!empty($setting['gst_no'])): ?>
                                                    <p class="mb-1 font-black-900" style="white-space:nowrap;">
                                                        <strong><?php echo e(getVatNoLabel() . ':'); ?>

                                                        </strong><?php echo e($setting['gst_no']); ?>

                                                    </p>
                                                <?php endif; ?>
                                            </td>
                                            <td width="30%" class="pe-3">
                                                <p class="mb-2"
                                                    style="white-space:nowrap;color:<?php echo e($invoice_template_color); ?>">
                                                    <strong><?php echo e(__('messages.common.to') . ':'); ?></strong>
                                                </p>
                                                <p class="mb-1 font-black-900 fw-bold" style="white-space:nowrap;">
                                                    <strong><?php echo e(__('messages.common.name') . ':'); ?>&nbsp;</strong><?php echo e($client->user->full_name); ?>

                                                </p>
                                                <p class="mb-1 font-black-900 fw-bold" style="white-space:nowrap;">
                                                    <strong><?php echo e(__('messages.common.email') . ':'); ?>&nbsp;</strong><?php echo e($client->user->email); ?>

                                                </p>
                                                <p class="mb-1 font-black-900 fw-bold">
                                                    <strong><?php echo e(__('messages.common.address') . ':'); ?>&nbsp;</strong><?php echo e($client->address); ?>

                                                </p>
                                                <?php if(!empty($client->vat_no)): ?>
                                                    <p class="mb-1 font-black-900 fw-bold" style="white-space:nowrap;">
                                                        <strong><?php echo e(getVatNoLabel() . ':'); ?>&nbsp;</strong><?php echo e($client->vat_no); ?>

                                                    </p>
                                                <?php endif; ?>
                                            </td>
                                            <td width="30%" class="text-center">
                                                <p class="mb-2" style="color:<?php echo e($invoice_template_color); ?>">
                                                    <strong><?php echo e(__('messages.common.scan_to_pay') . ':'); ?></strong>
                                                </p>
                                                <div>
                                                    <?php if(!empty($invoice->paymentQrCode) & !empty($invoice->paymentQrCode->qr_image)): ?>
                                                        <img src="<?php echo e($invoice->paymentQrCode->qr_image); ?>"
                                                            height="110" width="110" alt="qr-code-image">
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="overflow-auto w-100 mt-4">
                                <table class="invoice-table w-100">
                                    <thead style="background-color: <?php echo e($invoice_template_color); ?>">
                                        <tr>
                                            <th class="p-10px fs-5"><b>#</b></th>
                                            <th class="p-10px fs-5 in-w-2"><b><?php echo e(__('messages.product.product')); ?></b>
                                            </th>
                                            <th class="p-10px fs-5 text-center"><b><?php echo e(__('messages.invoice.qty')); ?></b>
                                            </th>
                                            <th class="p-10px fs-5 text-center text-nowrap">
                                                <b><?php echo e(__('messages.product.unit_price')); ?></b>
                                            </th>
                                            <th class="p-10px fs-5 text-center text-nowrap">
                                                <b><?php echo e(__('messages.invoice.tax') . '(in %)'); ?></b>
                                            </th>
                                            <th class="p-10px fs-5 text-end text-nowrap">
                                                <b><?php echo e(__('messages.invoice.amount')); ?></b>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if(!empty($invoice)): ?>
                                            <?php $__currentLoopData = $invoice->invoiceItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $invoiceItems): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td class="p-10px"><span><b><?php echo e($key + 1); ?></b></span></td>
                                                    <td class="p-10px font-gray-600 in-w-2">
                                                        <p class="fw-6 mb-0 font-black-900">
                                                            <?php echo e(isset($invoiceItems->product->name) ? $invoiceItems->product->name : $invoiceItems->product_name ?? __('messages.common.n/a')); ?>

                                                        </p>
                                                        <?php if(
                                                            !empty($invoiceItems->product->description) &&
                                                                (isset($setting['show_product_description']) && $setting['show_product_description'] == 1)): ?>
                                                            <span
                                                                style="font-size: 12px; word-break: break-all !important"><?php echo e($invoiceItems->product->description); ?></span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td class="p-10px font-gray-600 text-center">
                                                        <?php echo e(number_format($invoiceItems->quantity, 2)); ?></td>
                                                    <td class="p-10px font-gray-600 text-center tex-nowrap">
                                                        <?php echo e(isset($invoiceItems->price) ? getInvoiceCurrencyAmount($invoiceItems->price, $invoice->currency_id, true) : __('messages.common.n/a')); ?>

                                                    </td>
                                                    <td class="p-10px font-gray-600 text-center">
                                                        <?php $__currentLoopData = $invoiceItems->invoiceItemTax; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keys => $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php echo e($tax->tax ?? '--'); ?>

                                                            <?php if(!$loop->last): ?>
                                                                ,
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </td>
                                                    <td class="p-10px font-gray-600 text-end text-nowrap">
                                                        <?php echo e(isset($invoiceItems->total) ? getInvoiceCurrencyAmount($invoiceItems->total, $invoice->currency_id, true) : __('messages.common.n/a')); ?>

                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                            <div class="mt-4">
                                <table style="width:250px; margin-left:auto;">
                                    <tbody style="border-bottom:1px solid #cecece">
                                        <tr>
                                            <td class="pb-2" style="color:<?php echo e($invoice_template_color); ?>">
                                                <strong><?php echo e(__('messages.invoice.sub_total') . ':'); ?></strong>
                                            </td>
                                            <td class="text-end font-gray-600 pb-2 fw-bold">
                                                <?php echo e(getInvoiceCurrencyAmount($invoice->amount, $invoice->currency_id, true)); ?>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="pb-2" style="color:<?php echo e($invoice_template_color); ?>">
                                                <strong><?php echo e(__('messages.invoice.discount') . ':'); ?></strong>
                                            </td>
                                            <td class="text-end font-gray-600 pb-2 fw-bold">
                                                <?php if($invoice->discount == 0): ?>
                                                    <span><?php echo e(__('messages.common.n/a')); ?></span>
                                                <?php else: ?>
                                                    <?php if(isset($invoice) && $invoice->discount_type == \App\Models\Invoice::FIXED): ?>
                                                        <span
                                                            class="euroCurrency"><?php echo e(isset($invoice->discount) ? getInvoiceCurrencyAmount($invoice->discount, $invoice->currency_id, true) : __('messages.common.n/a')); ?></span>
                                                    <?php else: ?>
                                                        <?php echo e($invoice->discount); ?><span
                                                            style="font-family: DejaVu Sans">&#37;</span>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <?php
                                                $itemTaxesAmount = $invoice->amount + array_sum($totalTax);
                                                $invoiceTaxesAmount =
                                                    ($itemTaxesAmount * $invoice->invoiceTaxes->sum('value')) / 100;
                                                $totalTaxes = array_sum($totalTax) + $invoiceTaxesAmount;
                                            ?>
                                            <td class="pb-2" style="color:<?php echo e($invoice_template_color); ?>">
                                                <strong><?php echo e(__('messages.invoice.tax') . ':'); ?></strong>
                                            </td>
                                            <td class="text-end font-gray-600 pb-2 fw-bold">
                                                <?php echo numberFormat($totalTaxes) != 0
                                                    ? '<span class="euroCurrency">' . getInvoiceCurrencyAmount($totalTaxes, $invoice->currency_id, true) . '</span>'
                                                    : __('messages.common.n/a'); ?>

                                            </td>
                                        </tr>
                                    </tbody>
                                    <tfoot class="total-amount">
                                        <tr>
                                            <td class="py-2" style="color:<?php echo e($invoice_template_color); ?>">
                                                <strong><?php echo e(__('messages.invoice.total') . ':'); ?></strong>
                                            </td>
                                            <td class="text-end py-2">
                                                <?php echo e(getInvoiceCurrencyAmount($invoice->final_amount, $invoice->currency_id, true)); ?>

                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                            <div class="mt-5">
                                <?php if(!empty($invoice->note)): ?>
                                <div class="mb-5 mt-sm-0 mt-2">
                                    <h6 class="font-gray-900 mb5">
                                        <b><?php echo e(__('messages.client.notes') . ':'); ?></b>
                                    </h6>
                                    <p class="font-gray-600">
                                        <?php echo nl2br($invoice->note ?? __('messages.common.not_available')); ?>

                                    </p>
                                </div>
                                <?php endif; ?>
                                <table class="w-100">
                                    <tr>
                                        <?php if(!empty($invoice->term)): ?>
                                        <td class="w-50">
                                            <div>
                                                <h6 class="font-gray-900 mb5">
                                                    <b><?php echo e(__('messages.invoice.terms') . ':'); ?></b>
                                                </h6>
                                                <p class="font-gray-600 mb-0">
                                                    <?php echo nl2br($invoice->term ?? __('messages.common.not_available')); ?>

                                                </p>
                                            </div>
                                        </td>
                                        <?php endif; ?>
                                        <td style="vertical-align:bottom; width:25%;" class="text-end">
                                            <div>
                                                <h6 class="fw-6 mb5 pt-3">
                                                    <?php echo e(__('messages.setting.regards') . ':'); ?>

                                                </h6>
                                                <p class="fw-6 mb-0" style="color:<?php echo e($invoice_template_color); ?>">
                                                    <?php echo e(html_entity_decode($setting['app_name'])); ?></p>
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>

</html>
<?php /**PATH /Users/fowusu/Herd/ims/resources/views/invoices/invoice_template_pdf/parisTemplate.blade.php ENDPATH**/ ?>