<?php

namespace Database\Seeders;

use App\Models\Tax;
use Illuminate\Database\Seeder;

class GhanaTaxSeeder extends Seeder
{
       /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Clear existing taxes if needed (optional - comment out if you want to keep existing)
        // Tax::truncate();
        
        // Ghana VAT is 12.5% (standard rate)
        Tax::create([
            'name' => 'VAT (12.5%)',
            'value' => 12.5,
            'is_default' => true
        ]);
        
        // Zero-rated for some agricultural products
        Tax::create([
            'name' => 'Zero Rated',
            'value' => 0,
            'is_default' => false
        ]);
        
        // Optional: Exempt (if applicable)
        Tax::create([
            'name' => 'Exempt',
            'value' => 0,
            'is_default' => false
        ]);
    }
}