<?php

use App\Models\InvoiceSetting;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Check if Ghana template doesn't already exist
        $ghanaTemplate = InvoiceSetting::where('key', 'ghanaTemplate')->first();
        
        if (!$ghanaTemplate) {
            InvoiceSetting::create([
                'key' => 'ghanaTemplate',
                'template_name' => 'Ghana',
                'template_color' => '#2d5016', // Dark green color matching the template
            ]);
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        InvoiceSetting::where('key', 'ghanaTemplate')->delete();
    }
};
