<?php

namespace App\Http\Requests;

use App\Models\Client;
use Illuminate\Foundation\Http\FormRequest;

class CreateClientRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $rules = Client::$rules;

        // Only validate password_confirmation if password is provided
        if (!empty($this->password)) {
            $rules['password_confirmation'] = 'required_with:password|same:password';
        } else {
            $rules['password_confirmation'] = 'nullable';
        }

        return $rules;
    }

    /**
     * @return string[]
     */
    public function messages(): array
    {
        return [
            'password.same' => 'The password and confirm password must match',
            'password_confirmation.same' => 'The password and confirm password must match',
        ];
    }
}
